'use client';

import { useState } from 'react';
import Link from 'next/link';
import { usePathname } from 'next/navigation';

export default function NavBar() {
  const [isMenuOpen, setIsMenuOpen] = useState(false);
  const pathname = usePathname();

  const toggleMenu = () => {
    setIsMenuOpen(!isMenuOpen);
  };

  return (
    <nav className="bg-blue-600 shadow-lg">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between h-16">
          <div className="flex">
            <div className="flex-shrink-0 flex items-center">
              <Link 
                href="/"
                className="text-white font-bold text-xl"
              >
                FileMaker OData
              </Link>
            </div>
          </div>
          
          {/* Desktop navigation */}
          <div className="hidden md:ml-6 md:flex md:items-center md:space-x-4">
            <Link 
              href="/"
              className={`px-3 py-2 rounded-md text-sm font-medium ${
                pathname === '/' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
              }`}
            >
              Home
            </Link>
            <div className="flex items-center space-x-1">
              <Link 
                href="/clients-all"
                className={`px-3 py-2 rounded-md text-sm font-medium ${
                  pathname === '/clients-all' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
                }`}
              >
                All Clients
              </Link>
              <Link 
                href="/client-new"
                className={`px-2 py-1 rounded-md text-xs font-medium bg-green-600 text-white hover:bg-green-700`}
                title="New Client"
              >
                +
              </Link>
            </div>
            <div className="flex items-center space-x-1">
              <Link 
                href="/tasks-all"
                className={`px-3 py-2 rounded-md text-sm font-medium ${
                  pathname === '/tasks-all' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
                }`}
              >
                All Tasks
              </Link>
              <Link 
                href="/task-new"
                className={`px-2 py-1 rounded-md text-xs font-medium bg-green-600 text-white hover:bg-green-700`}
                title="New Task"
              >
                +
              </Link>
            </div>
            <Link 
              href="/client"
              className={`px-3 py-2 rounded-md text-sm font-medium ${
                pathname === '/client' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
              }`}
            >
              Client
            </Link>
            <Link 
              href="/tasks"
              className={`px-3 py-2 rounded-md text-sm font-medium ${
                pathname === '/tasks' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
              }`}
            >
              Tasks
            </Link>
            <Link 
              href="/login"
              className={`ml-2 px-3 py-2 rounded-md text-sm font-medium ${
                pathname === '/login' ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-500 bg-blue-700'
              }`}
            >
              Login
            </Link>
          </div>
          
          {/* Mobile menu button */}
          <div className="flex items-center md:hidden">
            <button 
              onClick={toggleMenu}
              className="inline-flex items-center justify-center p-2 rounded-md text-blue-100 hover:text-white hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white"
              aria-expanded="false"
            >
              <span className="sr-only">Open main menu</span>
              {/* Icon when menu is closed */}
              <svg 
                className={`${isMenuOpen ? 'hidden' : 'block'} h-6 w-6`} 
                xmlns="http://www.w3.org/2000/svg" 
                fill="none" 
                viewBox="0 0 24 24" 
                stroke="currentColor" 
                aria-hidden="true"
              >
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M4 6h16M4 12h16M4 18h16" />
              </svg>
              {/* Icon when menu is open */}
              <svg 
                className={`${isMenuOpen ? 'block' : 'hidden'} h-6 w-6`} 
                xmlns="http://www.w3.org/2000/svg" 
                fill="none" 
                viewBox="0 0 24 24" 
                stroke="currentColor" 
                aria-hidden="true"
              >
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M6 18L18 6M6 6l12 12" />
              </svg>
            </button>
          </div>
        </div>
      </div>
      
      {/* Mobile menu, show/hide based on menu state */}
      <div className={`${isMenuOpen ? 'block' : 'hidden'} md:hidden`}>
        <div className="px-2 pt-2 pb-3 space-y-1 sm:px-3">
          <Link 
            href="/"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            Home
          </Link>
          
          <Link 
            href="/clients-all"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/clients-all' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            All Clients
          </Link>
          
          <Link 
            href="/client-new"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/client-new' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            New Client
          </Link>
          
          <Link 
            href="/tasks-all"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/tasks-all' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            All Tasks
          </Link>
          
          <Link 
            href="/task-new"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/task-new' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            New Task
          </Link>
          
          <Link 
            href="/client"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/client' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            Client
          </Link>
          
          <Link 
            href="/tasks"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/tasks' ? 'bg-blue-700 text-white' : 'text-blue-100 hover:bg-blue-500'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            Tasks
          </Link>
          
          <Link 
            href="/login"
            className={`block px-3 py-2 rounded-md text-base font-medium ${
              pathname === '/login' ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-500 bg-blue-700'
            }`}
            onClick={() => setIsMenuOpen(false)}
          >
            Login
          </Link>
        </div>
      </div>
    </nav>
  );
}
